﻿//////////////////////////////////////////////
// AlignmentUtils.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	struct AlignmentDescriptor ;
}

namespace nkMemory
{
	class Buffer ;
}

/// Includes ---------------------------------

// nkImages
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages
{
	class DLL_IMAGES_EXPORT AlignmentUtils final
	{
		public :

			// Alignment rework
			static void realignPixelsAndRows (unsigned char* output, const unsigned char* input, unsigned int width, unsigned int height, unsigned int outputPixelSize, unsigned int outputRowSize, unsigned int inputPixelSize, unsigned int inputRowSize) ;
			static void realignPixelsAndRowsReorderRgb (unsigned char* output, const unsigned char* input, unsigned int width, unsigned int height, unsigned int outputPixelSize, unsigned int outputRowSize, unsigned int inputPixelSize, unsigned int inputRowSize, unsigned int channelByteSize) ;
			static void realignPixels (unsigned char* output, const unsigned char* input, unsigned int width, unsigned int height, unsigned int outputPixelSize, unsigned int inputPixelSize) ;
			static void realignPixelsReorderRgb (unsigned char* output, const unsigned char* input, unsigned int width, unsigned int height, unsigned int outputPixelSize, unsigned int inputPixelSize, unsigned int channelByteSize) ;
			static void realignRows (unsigned char* output, const unsigned char* input, unsigned int height, unsigned int outputRowSize, unsigned int inputRowSize) ;

			// Alignment information
			static unsigned int getAlignedSize (unsigned int byteSize, unsigned int byteAlignment) ;
	} ;
}